/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.sonarsource.sonarlint.core.container.connected.CloseableWsResponse;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class GlobalPropertiesDownloader {
    private final SonarLintWsClient wsClient;

    public GlobalPropertiesDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> fetchGlobalPropertiesTo(Path dest) {
        CloseableWsResponse response = this.wsClient.get("api/properties?format=json");
        try (JsonReader reader = new JsonReader(response.contentReader());){
            Sonarlint.GlobalProperties.Builder builder = Sonarlint.GlobalProperties.newBuilder();
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                GlobalPropertiesDownloader.parseProperty(reader, builder);
                reader.endObject();
            }
            reader.endArray();
            Sonarlint.GlobalProperties globalProperties = builder.build();
            ProtobufUtil.writeToFile(globalProperties, dest.resolve("properties.pb"));
            Set<String> set = GlobalPropertiesDownloader.getPluginWhitelist(globalProperties);
            return set;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse global properties from: " + response.content(), e);
        }
    }

    private static void parseProperty(JsonReader reader, Sonarlint.GlobalProperties.Builder builder) throws IOException {
        String key = null;
        String value = null;
        while (reader.hasNext()) {
            String propName = reader.nextName();
            if ("key".equals(propName)) {
                key = reader.nextString();
                continue;
            }
            if ("value".equals(propName)) {
                value = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        builder.getMutableProperties().put(key, value);
    }

    private static Set<String> getPluginWhitelist(Sonarlint.GlobalProperties globalProperties) {
        if (globalProperties.getProperties().containsKey("sonarlint.plugins.whitelist")) {
            String[] list = globalProperties.getProperties().get("sonarlint.plugins.whitelist").split(",");
            return ImmutableSet.copyOf(list);
        }
        return ImmutableSet.of("java", "javascript", "php");
    }
}

